/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe;

import com.fb.tpe.Data;
import com.fb.tpe.model.Model;
import com.fb.tpe.view.Splash;
import com.fb.tpe.view.View;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import javax.swing.JOptionPane;

public class TerrariaPlayerEditor {
    public static void main(String[] args) {
        try {
            new TerrariaPlayerEditor();
        }
        catch (NoClassDefFoundError error) {
            String message = "Missing class! Is the lib folder present?\n" + error.getMessage();
            JOptionPane.showMessageDialog(null, message, "Fatal error", 0);
            TerrariaPlayerEditor.throwError();
        }
    }

    public TerrariaPlayerEditor() {
        Splash.initSplashScreen();
        Data.setModel(new Model());
        Data.setView(new View());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Data.getView().validate();
                Data.getView().pack();
                TerrariaPlayerEditor.this.positionWindow();
                Data.getView().setVisible(true);
            }
        });
        Splash.setSplashProgress(1000);
        Splash.pauseSplashProgress(500);
        Splash.closeSplashScreen();
    }

    public static void throwError() {
        System.exit(1);
    }

    public static boolean exitApp() {
        boolean result = true;
        int proceed = 0;
        if (Data.getCharacterChanged()) {
            proceed = JOptionPane.showConfirmDialog(null, "Character is changed!\nDo you want to continue?", "Continue?", 0);
        }
        if (proceed == 0) {
            System.exit(0);
        } else {
            result = false;
        }
        return result;
    }

    private void positionWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = Data.getView().getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        int x = (screenSize.width - frameSize.width) / 2;
        int y = (int)((double)screenSize.height * 0.2);
        Data.getView().setLocation(x, y);
    }
}

