/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.model.data;

import com.fb.tpe.model.Model;
import com.fb.tpe.model.data.ItemObjectDAO;
import javax.swing.ImageIcon;

public class ItemObject
implements Comparable<ItemObject> {
    private int _itemId;
    private String _itemName;
    private int _itemType;
    private int _maxCount;
    private ImageIcon _itemImage;

    public ItemObject(int itemId, String itemName, int itemType, int maxCount) {
        this.setItemId(itemId, itemName);
        this._itemName = itemName;
        this._itemType = itemType;
        this._maxCount = maxCount;
        this.setItemImage();
    }

    public int getItemId() {
        return this._itemId;
    }

    public void setItemId(int itemId) {
        this._itemId = itemId;
    }

    public void setItemId(int itemId, String itemName) {
        this._itemId = itemId == 1 || itemId == 4 || itemId == 6 || itemId == 7 || itemId == 10 || itemId == 99 || itemId == 198 || itemId == 199 || itemId == 200 || itemId == 201 || itemId == 202 || itemId == 203 ? ItemObjectDAO.getOverloadedItemType(itemName) : itemId;
    }

    public String getItemName() {
        return this._itemName;
    }

    public void setItemName(String itemName) {
        this._itemName = itemName;
    }

    public int getItemType() {
        return this._itemType;
    }

    public void setItemType(int itemType) {
        this._itemType = itemType;
    }

    public int getItemMaxCount() {
        return this._maxCount;
    }

    public void setItemMaxCount(int maxCount) {
        this._maxCount = maxCount;
    }

    public ImageIcon getItemImage() {
        return this._itemImage;
    }

    private void setItemImage() {
        this._itemImage = Model.loadImageIcon("res/images/items/Item_" + this._itemId + ".png");
    }

    @Override
    public int compareTo(ItemObject object) {
        int result = 0;
        if (object instanceof ItemObject) {
            ItemObject itemObject = object;
            result = this._itemName.compareTo(itemObject.getItemName());
        }
        return result;
    }

    public String toString() {
        return this._itemName;
    }
}

