/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.dialog;

import com.fb.tpe.Data;
import com.fb.tpe.model.data.BuffObject;
import com.fb.tpe.model.data.BuffObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.panel.BuffsPanel;
import com.fb.tpe.view.ui.field.BuffCellRenderer;
import com.fb.tpe.view.ui.layout.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BuffChooserDialog
extends JDialog {
    private static final long serialVersionUID = -6325606095992799779L;
    private BuffsPanel _parent;
    private int _buffType;
    private BuffObject _choice;
    private BuffObject[] _buffObjects;
    private BuffObject _curBuffObject;
    JPanel panelBorder;
    JPanel panelContent;
    JPanel panelControls;
    JPanel panelFilter;
    JLabel labelFilter;
    JLabel labelSpacer;
    JTextField editFilter;
    JScrollPane scrollList;
    JPanel panelList;
    BuffCellRenderer buffCellRenderer;
    JList listBuffs;
    WindowFocusListener listenerWindowFocus = new WindowFocusListener(){

        @Override
        public void windowGainedFocus(WindowEvent event) {
            BuffChooserDialog.this.requestFilterFocus();
        }

        @Override
        public void windowLostFocus(WindowEvent event) {
            BuffChooserDialog.this.dialogLostFocus(event);
        }
    };
    ListSelectionListener listenerBuffList = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent event) {
            BuffChooserDialog.this.clickBuffList(event);
        }
    };
    DocumentListener listenerDocumentFilter = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent event) {
            BuffChooserDialog.this.setListData();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            BuffChooserDialog.this.setListData();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            BuffChooserDialog.this.setListData();
        }
    };

    private BuffChooserDialog(JFrame owner, BuffsPanel parent, int buffType, BuffObject curBuffObject) {
        super(owner);
        this._parent = parent;
        this._buffType = buffType;
        this._curBuffObject = curBuffObject;
        this.initGUI();
        this.populateFields();
    }

    public static void buffChooserDialog(JFrame owner, BuffsPanel parent, Point location, int buffType, BuffObject curBuffObject) {
        BuffChooserDialog bcd = new BuffChooserDialog(owner, parent, buffType, curBuffObject);
        bcd.pack();
        bcd.setLocation(location);
        bcd.setVisible(true);
    }

    public BuffObject getChosenBuff() {
        return this._choice;
    }

    private void setListData() {
        BuffObject[] filteredBuffs;
        ArrayList<BuffObject> filteredList = new ArrayList<BuffObject>();
        String filterValue = this.editFilter.getText().toLowerCase();
        if (!filterValue.isEmpty()) {
            filteredList.add(this._buffObjects[0]);
            int index = 1;
            while (index < this._buffObjects.length) {
                String buffName = this._buffObjects[index].getBuffName().toLowerCase();
                if (buffName.contains(filterValue)) {
                    filteredList.add(this._buffObjects[index]);
                }
                ++index;
            }
            filteredBuffs = new BuffObject[filteredList.size()];
            filteredList.toArray(filteredBuffs);
        } else {
            filteredBuffs = this._buffObjects;
        }
        this.listBuffs.setListData(filteredBuffs);
    }

    private void populateFields() {
        this.buffCellRenderer.setCurrentObject(this._curBuffObject);
        this._buffObjects = BuffObjectDAO.getBuffObjectsByType(this._buffType, true);
        this.listBuffs.setListData(this._buffObjects);
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    private void dialogLostFocus(WindowEvent event) {
        if (event.getOppositeWindow() != null && SwingUtilities.isDescendingFrom(event.getOppositeWindow(), this)) {
            return;
        }
        this.closeDialog();
    }

    private void clickBuffList(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting() && !this.listBuffs.isSelectionEmpty()) {
            this._choice = (BuffObject)this.listBuffs.getSelectedValue();
            this._parent.chooseBuffPanel(this._choice);
            Data.setCharacterDirty();
            this.setVisible(false);
        }
    }

    private void registerEscapeKey() {
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BuffChooserDialog.this.closeDialog();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void requestFilterFocus() {
        this.editFilter.requestFocusInWindow();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setBackground(GUI.colorChooserBack);
        this.addWindowFocusListener(this.listenerWindowFocus);
        this.setAlwaysOnTop(true);
        this.registerEscapeKey();
        this.panelBorder = new JPanel(new SpringLayout());
        this.panelBorder.setBackground(GUI.colorChooserBack);
        this.panelContent = new JPanel(new BorderLayout());
        this.panelControls = new JPanel(new BorderLayout());
        this.panelControls.setBorder(GUI.borderEmptyLRT5px);
        this.panelControls.setBackground(GUI.colorChooserFront);
        this.panelFilter = new JPanel(new BorderLayout());
        this.labelFilter = new JLabel(" Filter: ");
        this.panelFilter.setBackground(GUI.colorChooserFront);
        this.editFilter = new JTextField("");
        this.editFilter.setBorder(GUI.borderEditField);
        this.editFilter.getDocument().addDocumentListener(this.listenerDocumentFilter);
        this.labelSpacer = new JLabel("     ");
        this.scrollList = new JScrollPane();
        this.scrollList.setVerticalScrollBarPolicy(22);
        this.scrollList.setHorizontalScrollBarPolicy(31);
        this.panelList = new JPanel(new BorderLayout());
        this.panelList.setBackground(GUI.colorChooserFront);
        this.listBuffs = new JList();
        this.listBuffs.setSelectionMode(0);
        this.buffCellRenderer = new BuffCellRenderer();
        this.listBuffs.setCellRenderer(this.buffCellRenderer);
        this.listBuffs.setBackground(GUI.colorBuffCell);
        this.listBuffs.addListSelectionListener(this.listenerBuffList);
        this.add(this.panelBorder);
        this.panelBorder.add((Component)this.panelContent, "Center");
        this.panelContent.add((Component)this.panelControls, "North");
        this.panelControls.add((Component)this.panelFilter, "Center");
        this.panelFilter.add((Component)this.labelFilter, "West");
        this.panelFilter.add((Component)this.editFilter, "Center");
        this.panelFilter.add((Component)this.labelSpacer, "East");
        this.panelContent.add((Component)this.panelList, "South");
        this.panelList.add((Component)this.scrollList, "Center");
        this.scrollList.getViewport().add(this.listBuffs);
        SpringUtilities.makeCompactGrid(this.panelBorder, 1, 1, 2, 2, 2, 2);
    }
}

