/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.menu;

import com.fb.tpe.Data;
import com.fb.tpe.TerrariaPlayerEditor;
import com.fb.tpe.model.Model;
import com.fb.tpe.view.GUI;
import com.su.slytherin.terraria.player.Player;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MenuFile
extends JMenu {
    private static final long serialVersionUID = -3428468201178448941L;
    private int _mnemonic;
    JMenuItem menuFileNew;
    static JButton buttonFileNew;
    JMenuItem menuFileOpen;
    static JButton buttonFileOpen;
    JMenuItem menuFileSave;
    static JButton buttonFileSave;
    JMenuItem menuFileSaveAs;
    static JButton buttonFileSaveAs;
    JMenuItem menuFileExit;
    ActionListener listenerMenuFileNew = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuFile.this.eventMenuFileNew();
        }
    };
    ActionListener listenerMenuFileOpen = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuFile.this.eventMenuFileOpen();
        }
    };
    ActionListener listenerMenuFileSave = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuFile.this.eventMenuFileSave();
        }
    };
    ActionListener listenerMenuFileSaveAs = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuFile.this.eventMenuFileSaveAs();
        }
    };
    ActionListener listenerMenuFileExit = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuFile.this.eventMenuFileExit();
        }
    };

    public MenuFile(String name, int mnemonic) {
        super(name);
        this._mnemonic = mnemonic;
        this.initGUI();
    }

    public static void addToolBarChoices(JToolBar toolBar) {
        toolBar.add(buttonFileNew);
        toolBar.add(buttonFileOpen);
        toolBar.add(buttonFileSave);
        toolBar.add(buttonFileSaveAs);
    }

    public void setControlsEnabled(boolean enabled) {
        this.menuFileSave.setEnabled(enabled);
        buttonFileSave.setEnabled(enabled);
        this.menuFileSaveAs.setEnabled(enabled);
        buttonFileSaveAs.setEnabled(enabled);
    }

    private void openFile(File file) {
        try {
            Data.getModel().loadPlayer(file);
            Data.setPlayerFile(file);
            Data.setCharLoading(true);
            Data.getView().populateFields();
            Data.getView().getMenu().setControlsEnabled(true);
            Data.setCharLoading(false);
            Data.setCharacterClean();
        }
        catch (IOException error) {
            JOptionPane.showMessageDialog(Data.getView(), "File Error: " + error.getMessage(), "File Error: Terraria Player Editor (v1.08)", 0);
        }
        catch (Exception error) {
            JOptionPane.showMessageDialog(Data.getView(), "Error: " + error.getMessage(), "Error: Terraria Player Editor (v1.08)", 0);
        }
    }

    private void saveFile() {
        try {
            Data.getView().updatePlayer();
            Data.getModel().backupFile(Data.getPlayerFile());
            Data.getModel().savePlayer();
            Data.setCharacterClean();
        }
        catch (IOException error) {
            JOptionPane.showMessageDialog(Data.getView(), "File Error: " + error.getMessage(), "File Error: Terraria Player Editor (v1.08)", 0);
        }
        JOptionPane.showMessageDialog(Data.getView(), String.valueOf(Data.getPlayer().getName()) + " saved to " + Data.getPlayerFile(), "Terraria Player Editor (v1.08)", 1);
    }

    public void eventMenuFileNew() {
        int proceed = 0;
        if (Data.getCharacterChanged()) {
            proceed = JOptionPane.showConfirmDialog(Data.getView(), "Character is changed!\nDo you want to continue?", "Continue?", 0);
        }
        if (proceed == 0) {
            Data.setPlayer(Player.createDefault("NewPlayer"));
            Data.setPlayerFile(null);
            Data.getView().populateFields();
            Data.setCharacterDirty();
            Data.getView().getMenu().setControlsEnabled(true);
            this.menuFileSave.setEnabled(false);
            buttonFileSave.setEnabled(false);
        }
    }

    public void eventMenuFileOpen() {
        int proceed = 0;
        if (Data.getCharacterChanged()) {
            proceed = JOptionPane.showConfirmDialog(Data.getView(), "Character is changed!\nDo you want to continue?", "Continue?", 0);
        }
        if (proceed == 0) {
            int result;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileNameExtensionFilter("Player files and backups", "plr", "bak", "tpe"));
            if (Data.OS.contains("windows")) {
                chooser.setCurrentDirectory(new File(chooser.getCurrentDirectory(), "My Games/Terraria/Players/"));
            }
            if (Data.OS.contains("mac")) {
                String macHome = String.valueOf(System.getProperty("user.home")) + File.separator + "Documents";
                chooser.setCurrentDirectory(new File(String.valueOf(macHome) + "My Games/Terraria/Players/"));
            }
            if ((result = chooser.showOpenDialog(Data.getView())) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.openFile(selectedFile);
            }
        }
    }

    public void eventMenuFileSave() {
        if (Data.getPlayer() != null) {
            this.saveFile();
        }
    }

    public void eventMenuFileSaveAs() {
        int overwrite = 0;
        if (Data.getPlayer() != null) {
            int result;
            String chrName = Data.getView().getCharacterPanel().getCharacterName();
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileNameExtensionFilter("Player files and backups", "plr", "bak"));
            chooser.setSelectedFile(new File(chrName));
            if (Data.OS.contains("windows")) {
                chooser.setCurrentDirectory(new File(chooser.getCurrentDirectory(), "My Games/Terraria/Players/"));
            }
            if (Data.OS.contains("mac")) {
                String macHome = String.valueOf(System.getProperty("user.home")) + File.separator + "Documents";
                chooser.setCurrentDirectory(new File(String.valueOf(macHome) + "My Games/Terraria/Players/"));
            }
            if ((result = chooser.showSaveDialog(Data.getView())) == 0) {
                File selectedFile = chooser.getSelectedFile();
                String fileName = selectedFile.toString();
                if (!fileName.endsWith(".plr")) {
                    fileName = String.valueOf(selectedFile.getPath()) + ".plr";
                }
                if (new File(fileName).exists()) {
                    overwrite = JOptionPane.showConfirmDialog(Data.getView(), "Character exists!\nDo you want to overwrite?", "Continue?", 0);
                }
                if (overwrite == 0) {
                    Data.setPlayerFile(new File(fileName));
                    this.saveFile();
                    this.menuFileSave.setEnabled(true);
                    buttonFileSave.setEnabled(true);
                }
            }
        }
    }

    public boolean eventMenuFileExit() {
        return TerrariaPlayerEditor.exitApp();
    }

    private void initGUI() {
        this.setFont(GUI.fontSsP14);
        this.setMnemonic(this._mnemonic);
        this.menuFileNew = this.setupMenuItem("New", "Create a new Character", 78, 78, this.listenerMenuFileNew, true);
        buttonFileNew = this.setupMenuButton("res/images/ui/MenuFileNew", "Create a new Character", this.listenerMenuFileNew, true);
        this.menuFileOpen = this.setupMenuItem("Open", "Open an existing Character", 79, 79, this.listenerMenuFileOpen, true);
        buttonFileOpen = this.setupMenuButton("res/images/ui/MenuFileOpen", "Open an existing Character", this.listenerMenuFileOpen, true);
        this.menuFileSave = this.setupMenuItem("Save", "Save the current Character over the current name", 83, 83, this.listenerMenuFileSave, false);
        buttonFileSave = this.setupMenuButton("res/images/ui/MenuFileSave", "Save the current Character over the current name", this.listenerMenuFileSave, false);
        this.menuFileSaveAs = this.setupMenuItem("Save As ...", "Save the current Character with a new file name", 65, 65, this.listenerMenuFileSaveAs, false);
        buttonFileSaveAs = this.setupMenuButton("res/images/ui/MenuFileSaveAs", "Save the current Character with a new file name", this.listenerMenuFileSaveAs, false);
        this.menuFileExit = this.setupMenuItem("Exit", "Exit Terraria Player Editor", 88, 88, this.listenerMenuFileExit, true);
        this.add(this.menuFileNew);
        this.add(this.menuFileOpen);
        this.add(this.menuFileSave);
        this.add(this.menuFileSaveAs);
        this.add(this.menuFileExit);
    }

    private JMenuItem setupMenuItem(String menuName, String toolTip, int mnemonic, int keyEvent, ActionListener listener, boolean enabled) {
        JMenuItem result = new JMenuItem();
        result.setText(menuName);
        result.setToolTipText(toolTip);
        result.setFont(GUI.fontSsP14);
        result.setMnemonic(mnemonic);
        if (keyEvent != 0) {
            result.setAccelerator(KeyStroke.getKeyStroke(keyEvent, 2));
        }
        result.setEnabled(enabled);
        result.addActionListener(listener);
        return result;
    }

    private JButton setupMenuButton(String imageName, String toolTip, ActionListener listener, boolean enabled) {
        JButton result = new JButton();
        result.setBorder(GUI.borderEmpty2px);
        result.setContentAreaFilled(false);
        result.setFocusPainted(false);
        result.setIcon(Model.loadImageIcon(String.valueOf(imageName) + ".png"));
        result.setRolloverEnabled(true);
        result.setRolloverIcon(Model.loadImageIcon(String.valueOf(imageName) + "Roll.png"));
        result.setToolTipText(toolTip);
        result.setEnabled(enabled);
        result.addActionListener(listener);
        return result;
    }
}

