/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.panel;

import com.fb.tpe.Data;
import com.fb.tpe.TerrariaPlayerEditor;
import com.fb.tpe.model.data.BuffObject;
import com.fb.tpe.model.data.BuffObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.dialog.BuffChooserDialog;
import com.fb.tpe.view.ui.panel.BuffPanel;
import com.fb.tpe.view.ui.panel.BuffPanelInterface;
import com.su.slytherin.terraria.player.Buff;
import com.su.slytherin.terraria.player.BuffList;
import com.su.slytherin.terraria.player.Player;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BuffsPanel
extends JPanel
implements BuffPanelInterface {
    private static final long serialVersionUID = -7525388248280149746L;
    private Player _player;
    private BuffList _buffs;
    private BuffPanel _buffPanel;
    JPanel panelBuffs;

    public BuffsPanel() {
        this.initGUI();
    }

    public void populateFields() {
        this._player = Data.getPlayer();
        if (this._player != null) {
            this._buffs = this._player.getBuffs();
            if (this._buffs != null) {
                int position = 0;
                while (position < 10) {
                    BuffPanel buffPanel = (BuffPanel)this.panelBuffs.getComponent(position);
                    Buff buff = this._buffs.getBuff(position);
                    BuffObject buffObject = BuffObjectDAO.getBuffObjectByNum(buff.getType());
                    BuffsPanel.setBuffPanel(buffPanel, buffObject, buff.getTime());
                    ++position;
                }
            } else {
                JOptionPane.showMessageDialog(Data.getView(), "Unable to load buffs data", "Buffs Error", 0);
                TerrariaPlayerEditor.throwError();
            }
        } else {
            JOptionPane.showMessageDialog(Data.getView(), "Unable to load player data", "Player Error", 0);
            TerrariaPlayerEditor.throwError();
        }
    }

    public void updatePlayer() {
        int position = 0;
        while (position < 10) {
            BuffPanel buffPanel = (BuffPanel)this.panelBuffs.getComponent(position);
            BuffObject buffObject = buffPanel.getBuffObject();
            Buff buff = Buff.of(buffObject.getBuffNum(), buffPanel.getBuffTime());
            this._buffs.setBuff(position, buff);
            ++position;
        }
        this._player.setBuffs(this._buffs);
        Data.setPlayer(this._player);
    }

    public void clearAll() {
        int position = 0;
        while (position < 10) {
            BuffPanel buffPanel = (BuffPanel)this.panelBuffs.getComponent(position);
            BuffsPanel.setBuffPanel(buffPanel, null, 0);
            ++position;
        }
    }

    private static void setBuffPanel(BuffPanel buffPanel, BuffObject buffObject, int buffTime) {
        if (buffObject != null && !buffObject.equals(BuffObjectDAO.EMPTY_BUFF)) {
            String time = buffTime != 0 ? Integer.toString(buffTime) : "";
            buffPanel.setBuff(buffObject, time);
        } else {
            buffPanel.setBuff(BuffObjectDAO.EMPTY_BUFF, "");
        }
    }

    @Override
    public void clickBuffPanel(BuffPanel buffPanel, int buffType) {
        this._buffPanel = buffPanel;
        Point location = buffPanel.getLocationOnScreen();
        location.x += buffPanel.getWidth();
        location.y -= 18;
        BuffChooserDialog.buffChooserDialog(Data.getView(), this, location, buffType, buffPanel.getBuffObject());
    }

    @Override
    public void chooseBuffPanel(BuffObject chosenBuff) {
        int buffTime = 1;
        if (chosenBuff != null) {
            if (Data.getUseMaxAmount()) {
                buffTime = chosenBuff.getBuffMaxTime();
            }
            BuffsPanel.setBuffPanel(this._buffPanel, chosenBuff, buffTime);
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.panelBuffs = new JPanel(new GridLayout(4, 3));
        this.panelBuffs.setBorder(GUI.setupAreaBorder("Buffs"));
        this.panelBuffs.setOpaque(false);
        this.add((Component)this.panelBuffs, "West");
        int position = 0;
        while (position < 10) {
            this.panelBuffs.add(new BuffPanel(this, 0, GUI.colorBuffsBuff));
            ++position;
        }
        this.add(Box.createHorizontalGlue(), "Center");
    }
}

