/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.panel;

import com.fb.tpe.Data;
import com.fb.tpe.TerrariaPlayerEditor;
import com.fb.tpe.model.data.ItemObject;
import com.fb.tpe.model.data.ItemObjectDAO;
import com.fb.tpe.model.data.PrefixObject;
import com.fb.tpe.model.data.PrefixObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.dialog.ItemChooserDialog;
import com.fb.tpe.view.dialog.PrefixChooserDialog;
import com.fb.tpe.view.ui.panel.ItemPanel;
import com.fb.tpe.view.ui.panel.ItemPanelInterface;
import com.su.slytherin.terraria.player.InvStack;
import com.su.slytherin.terraria.player.Item;
import com.su.slytherin.terraria.player.Player;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class InventoryPanel
extends JPanel
implements ItemPanelInterface {
    private static final long serialVersionUID = 4217711194147731371L;
    private Player _player;
    private InvStack _inve;
    private InvStack _coin;
    private InvStack _ammo;
    private ItemPanel _itemPanel;
    JPanel panelInve;
    JPanel panelCoinAmmo;
    JPanel panelCoin;
    JPanel panelAmmo;

    public InventoryPanel() {
        this.initGUI();
    }

    public void populateFields() {
        this._player = Data.getPlayer();
        if (this._player != null) {
            ItemObject itemObject;
            int prefixId;
            Item item;
            ItemPanel itemPanel;
            int position;
            this._inve = this._player.getInventory();
            if (this._inve != null) {
                position = 0;
                while (position < 40) {
                    itemPanel = (ItemPanel)this.panelInve.getComponent(position);
                    item = this._inve.getItem(position);
                    prefixId = item.getPrefix();
                    itemObject = ItemObjectDAO.getItemObjectById(item.getItemId());
                    InventoryPanel.setItemPanel(itemPanel, itemObject, prefixId, this._inve.getItemCount(position));
                    ++position;
                }
            } else {
                JOptionPane.showMessageDialog(Data.getView(), "Unable to load inventory data", "Inventory Error", 0);
                TerrariaPlayerEditor.throwError();
            }
            this._coin = this._player.getCoins();
            if (this._coin != null) {
                position = 0;
                while (position < 4) {
                    itemPanel = (ItemPanel)this.panelCoin.getComponent(position);
                    item = this._coin.getItem(position);
                    itemObject = ItemObjectDAO.getItemObjectById(item.getItemId());
                    InventoryPanel.setItemPanel(itemPanel, itemObject, 0, this._coin.getItemCount(position));
                    ++position;
                }
            } else {
                JOptionPane.showMessageDialog(Data.getView(), "Unable to load coin data", "Ammo Error", 0);
                TerrariaPlayerEditor.throwError();
            }
            this._ammo = this._player.getAmmo();
            if (this._ammo != null) {
                position = 0;
                while (position < 4) {
                    itemPanel = (ItemPanel)this.panelAmmo.getComponent(position);
                    item = this._ammo.getItem(position);
                    prefixId = item.getPrefix();
                    itemObject = ItemObjectDAO.getItemObjectById(item.getItemId());
                    InventoryPanel.setItemPanel(itemPanel, itemObject, prefixId, this._ammo.getItemCount(position));
                    ++position;
                }
            } else {
                JOptionPane.showMessageDialog(Data.getView(), "Unable to load ammo data", "Ammo Error", 0);
                TerrariaPlayerEditor.throwError();
            }
        } else {
            JOptionPane.showMessageDialog(Data.getView(), "Unable to load player data", "Player Error", 0);
            TerrariaPlayerEditor.throwError();
        }
    }

    public void updatePlayer() {
        Item item;
        ItemPanel itemPanel;
        int position = 0;
        while (position < 40) {
            itemPanel = (ItemPanel)this.panelInve.getComponent(position);
            item = Item.of(itemPanel.getItemId(), itemPanel.getPrefixId());
            this._inve.setItem(position, item);
            this._inve.setItemCount(position, itemPanel.getItemCount());
            ++position;
        }
        position = 0;
        while (position < 4) {
            itemPanel = (ItemPanel)this.panelCoin.getComponent(position);
            item = Item.of(itemPanel.getItemId(), itemPanel.getPrefixId());
            this._coin.setItem(position, item);
            this._coin.setItemCount(position, itemPanel.getItemCount());
            ++position;
        }
        position = 0;
        while (position < 4) {
            itemPanel = (ItemPanel)this.panelAmmo.getComponent(position);
            item = Item.of(itemPanel.getItemId(), itemPanel.getPrefixId());
            this._ammo.setItem(position, item);
            this._ammo.setItemCount(position, itemPanel.getItemCount());
            ++position;
        }
        this._player.setAmmo(this._ammo);
        this._player.setCoins(this._coin);
        this._player.setInventory(this._inve);
        Data.setPlayer(this._player);
    }

    public void clearAll() {
        ItemPanel itemPanel;
        int position = 0;
        while (position < 40) {
            itemPanel = (ItemPanel)this.panelInve.getComponent(position);
            InventoryPanel.setItemPanel(itemPanel, null, 0, 0);
            ++position;
        }
        position = 0;
        while (position < 4) {
            itemPanel = (ItemPanel)this.panelCoin.getComponent(position);
            InventoryPanel.setItemPanel(itemPanel, null, 0, 0);
            ++position;
        }
        position = 0;
        while (position < 4) {
            itemPanel = (ItemPanel)this.panelAmmo.getComponent(position);
            InventoryPanel.setItemPanel(itemPanel, null, 0, 0);
            ++position;
        }
    }

    private static void setItemPanel(ItemPanel itemPanel, ItemObject itemObject, int prefixId, int itemCount) {
        if (itemObject != null && !itemObject.equals(ItemObjectDAO.getEmptyItem())) {
            String count = itemCount != 0 ? Integer.toString(itemCount) : "";
            itemPanel.setItem(itemObject, prefixId, count);
        } else {
            itemPanel.setItem(ItemObjectDAO.getEmptyItem(), 0, "");
        }
    }

    @Override
    public void clickItemPanel(ItemPanel itemPanel, int itemType) {
        boolean showControls = true;
        this._itemPanel = itemPanel;
        Point location = itemPanel.getLocationOnScreen();
        location.x += itemPanel.getWidth();
        if (itemPanel.getParent().equals(this.panelCoin) || itemPanel.getParent().equals(this.panelAmmo)) {
            showControls = false;
            location.y -= 7;
        } else {
            location.y -= 105;
        }
        ItemChooserDialog.itemChooserDialog(Data.getView(), this, location, showControls, itemType, itemPanel.getItemObject());
    }

    @Override
    public void chooseItemPanel(ItemObject chosenItem) {
        int itemCount = 1;
        if (chosenItem != null) {
            if (Data.getUseMaxAmount()) {
                itemCount = chosenItem.getItemMaxCount();
                if (!Data.getLimitAmounts() && chosenItem.getItemMaxCount() > 1) {
                    itemCount = 999;
                }
            }
            InventoryPanel.setItemPanel(this._itemPanel, chosenItem, 0, itemCount);
        }
    }

    @Override
    public void clickPrefix(ItemPanel itemPanel) {
        this._itemPanel = itemPanel;
        int itemType = itemPanel.getItemObject().getItemType();
        PrefixObject prefixObject = PrefixObjectDAO.getPrefixObjectById(itemPanel.getPrefixId());
        Point location = itemPanel.getLocationOnScreen();
        location.y -= 8;
        PrefixChooserDialog.prefixChooserDialog((JFrame)Data.getView(), this, location, itemType, prefixObject);
    }

    @Override
    public void choosePrefix(PrefixObject chosenPrefix) {
        ItemObject currentItem;
        int itemCount = 1;
        if (this._itemPanel != null && (currentItem = this._itemPanel.getItemObject()) != null) {
            if (Data.getUseMaxAmount()) {
                itemCount = currentItem.getItemMaxCount();
            }
            InventoryPanel.setItemPanel(this._itemPanel, currentItem, chosenPrefix.getPrefixId(), itemCount);
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.panelInve = new JPanel(new GridLayout(4, 10));
        this.panelInve.setBorder(GUI.setupAreaBorder("Inventory"));
        this.panelInve.setOpaque(false);
        this.panelCoinAmmo = new JPanel(new GridLayout(1, 2));
        this.panelCoinAmmo.setOpaque(false);
        this.panelCoin = new JPanel(new GridLayout(4, 1));
        this.panelCoin.setBorder(GUI.setupAreaBorder("Coins"));
        this.panelCoin.setOpaque(false);
        this.panelAmmo = new JPanel(new GridLayout(4, 1));
        this.panelAmmo.setBorder(GUI.setupAreaBorder("Ammo"));
        this.panelAmmo.setOpaque(false);
        this.add((Component)this.panelInve, "Center");
        int position = 0;
        while (position < 40) {
            this.panelInve.add(new ItemPanel(this, 0, GUI.colorInvenInv));
            ++position;
        }
        this.add((Component)this.panelCoinAmmo, "East");
        this.panelCoinAmmo.add(this.panelCoin);
        position = 0;
        while (position < 4) {
            this.panelCoin.add(new ItemPanel(this, 7, GUI.colorInvenCoin));
            ++position;
        }
        this.panelCoinAmmo.add(this.panelAmmo);
        position = 0;
        while (position < 4) {
            this.panelAmmo.add(new ItemPanel(this, 2, GUI.colorInvenAmmo));
            ++position;
        }
    }
}

