/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.ui.field;

import com.fb.tpe.model.data.HairObject;
import com.fb.tpe.view.GUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class HairCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 9154222208814846938L;
    private HairObject _currentObject;

    public void setCurrentObject(HairObject currentObject) {
        this._currentObject = currentObject;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
        if (value instanceof HairObject) {
            HairObject selObject = (HairObject)value;
            ImageIcon icon = selObject.getHairImage();
            result.setBackground(GUI.colorHairCell);
            if (selObject.equals(this._currentObject)) {
                result.setBackground(GUI.colorHairSelCell);
            }
            if (selected) {
                result.setBackground(GUI.colorHairFocusCell);
            }
            result.setBorder(GUI.borderLineLG1px);
            if (icon != null) {
                try {
                    result.setIcon(icon);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                int iconGap = 5 + (GUI.DIM_HAIR.width - icon.getIconWidth());
                result.setIconTextGap(iconGap);
            }
            result.setFont(GUI.fontSsB14);
            FontMetrics fontMetrics = result.getFontMetrics(result.getFont());
            int labelWidth = fontMetrics.stringWidth(result.getText());
            int width = GUI.DIM_ICON.width * 2 + labelWidth;
            result.setPreferredSize(new Dimension(width, GUI.DIM_ICON.height));
            result.setMinimumSize(new Dimension(width, GUI.DIM_ICON.height));
            result.setMaximumSize(new Dimension(width, GUI.DIM_ICON.height));
        }
        return this;
    }
}

