/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.ui.field;

import com.fb.tpe.Data;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class PopupWiki
extends JPopupMenu {
    private static final long serialVersionUID = -1718277316572399124L;
    private String _wikiTopic;
    JMenuItem popupMenu;
    ActionListener listenerPopupMenu = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupWiki.this.eventMenuPopup();
        }
    };

    public PopupWiki(String wikiTopic) {
        this._wikiTopic = wikiTopic;
        this.initGUI();
    }

    String getWikiTopic() {
        return this._wikiTopic;
    }

    private String underscoreName(String name) {
        return name.replaceAll(" ", "_");
    }

    private void eventMenuPopup() {
        try {
            URI uri = new URI("http://wiki.terrariaonline.com/" + this.underscoreName(this.getWikiTopic()));
            Desktop desktop = null;
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
            }
            if (desktop != null) {
                desktop.browse(uri);
            }
        }
        catch (IOException error) {
            JOptionPane.showMessageDialog(Data.getView(), "^Wiki Error: " + error.getMessage(), "Wiki Error: Terraria Player Editor (v1.08)", 0);
        }
        catch (URISyntaxException error) {
            JOptionPane.showMessageDialog(Data.getView(), "@Wiki Error: " + error.getMessage(), "Wiki Error: Terraria Player Editor (v1.08)", 0);
        }
    }

    private void initGUI() {
        this.popupMenu = new JMenuItem("Show Wiki for: " + this._wikiTopic);
        this.popupMenu.addActionListener(this.listenerPopupMenu);
        this.add(this.popupMenu);
    }
}

