/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.ui.panel;

import com.fb.tpe.model.data.ItemObject;
import com.fb.tpe.model.data.ItemObjectDAO;
import com.fb.tpe.model.data.ItemTypes;
import com.fb.tpe.model.data.PrefixObject;
import com.fb.tpe.model.data.PrefixObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.ui.field.PopupClickListener;
import com.fb.tpe.view.ui.panel.EquipPanelInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EquipPanel
extends JPanel {
    private static final long serialVersionUID = -8161910619030279528L;
    private EquipPanelInterface _parent = null;
    private int _itemType = 0;
    private ItemObject _itemObject = null;
    private int _itemId = 0;
    private String _itemName = "";
    private int _prefixId = 0;
    private String _title = "";
    private Color _color = null;
    JPanel panelEquip;
    JPanel panelPrefix;
    JPanel panelItem;
    JLabel labelTitle;
    JLabel labelName;
    JButton buttonPrefix;
    JButton imageIcon;
    PopupClickListener popupItem;
    PopupClickListener popupPrefix;
    ActionListener listenerButton = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            EquipPanel.this.clickEquipPanel();
        }
    };
    ActionListener listenerPrefix = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            EquipPanel.this.clickPrefix();
        }
    };

    public EquipPanel(EquipPanelInterface parent, int itemType, Color color, String title) {
        this._parent = parent;
        this._itemType = itemType;
        this._title = title;
        this._color = color;
        this.initGUI();
    }

    public void setItem(ItemObject itemObject, int prefixId) {
        String toolTip;
        this._itemObject = itemObject;
        this._itemId = itemObject.getItemId();
        ImageIcon itemIcon = itemObject.getItemImage();
        String itemName = itemObject.getItemName();
        String prefixName = PrefixObjectDAO.getPrefixName(prefixId);
        if (itemName == null) {
            itemName = "";
        }
        this._itemName = itemName;
        this.imageIcon.setIcon(itemIcon);
        if (!this._itemObject.equals(ItemObjectDAO.getEmptyItem())) {
            this.labelName.setText(this._itemName);
            this.labelName.setToolTipText(this._itemName);
            this.imageIcon.setToolTipText(this._itemName);
            toolTip = "<html><font color=\"maroon\"><b>" + itemName + "</b></font><br/>" + "<font color=\"" + "yellow" + "\">" + ItemTypes.ITEM_TYPES[this._itemObject.getItemType()] + "</font></html>";
            this.labelName.setToolTipText(toolTip);
            this.imageIcon.setToolTipText(toolTip);
            this.popupItem.setWikiTopic(this._itemName);
        } else {
            this.labelName.setText(" ");
            this.labelName.setToolTipText("No Item");
            this.imageIcon.setToolTipText("No Item");
            this.popupItem.setWikiTopic(null);
        }
        this._prefixId = prefixId;
        if (this._prefixId != 0) {
            PrefixObject prefixObject = PrefixObjectDAO.getPrefixObjectById(prefixId);
            this.buttonPrefix.setText(prefixName);
            toolTip = "<html><font color=\"blue\"><b>" + prefixName + "</b></font><br/>" + prefixObject.getPrefixTip() + "</html>";
            this.buttonPrefix.setToolTipText(toolTip);
            this.popupPrefix.setWikiTopic("Prefix");
        } else {
            this.buttonPrefix.setText(" ");
            this.buttonPrefix.setToolTipText("No Prefix");
            this.popupPrefix.setWikiTopic(null);
        }
    }

    public ItemObject getItemObject() {
        return this._itemObject;
    }

    public int getItemId() {
        return this._itemId;
    }

    public JPanel getPanelImage() {
        return this.panelEquip;
    }

    public int getPrefixId() {
        return this._prefixId;
    }

    private void clickEquipPanel() {
        this._parent.clickItemPanel((EquipPanel)this.imageIcon.getParent().getParent().getParent(), this._itemType);
    }

    private void clickPrefix() {
        if (!this._itemObject.equals(ItemObjectDAO.getEmptyItem()) && PrefixObjectDAO.isPrefixAllowed(this._itemObject)) {
            this._parent.clickPrefix((EquipPanel)this.imageIcon.getParent().getParent().getParent());
        }
    }

    private void initGUI() {
        this.setLayout(new GridLayout(1, 1));
        this.setOpaque(false);
        this.setBorder(GUI.borderEtched);
        this.labelTitle = new JLabel(" " + this._title);
        this.labelTitle.setFont(GUI.fontSsB14);
        this.panelEquip = new JPanel(new BorderLayout());
        this.panelEquip.setOpaque(true);
        this.panelEquip.setBorder(GUI.borderItemPanel);
        this.panelEquip.setBackground(this._color);
        this.panelPrefix = new JPanel(new BorderLayout());
        this.panelPrefix.setOpaque(false);
        this.buttonPrefix = new JButton("");
        this.buttonPrefix.setFocusPainted(false);
        this.buttonPrefix.setFont(GUI.fontSsP12);
        this.buttonPrefix.setBackground(this._color.brighter());
        this.buttonPrefix.setBorder(GUI.borderLineGR1px);
        this.buttonPrefix.addActionListener(this.listenerPrefix);
        this.popupPrefix = new PopupClickListener();
        this.buttonPrefix.addMouseListener(this.popupPrefix);
        this.panelItem = new JPanel(new BorderLayout());
        this.panelItem.setOpaque(false);
        this.labelName = new JLabel("");
        this.labelName.setFont(GUI.fontSsP14);
        this.labelName.setOpaque(true);
        this.labelName.setBackground(this._color.brighter().brighter());
        this.labelName.setBorder(GUI.borderEmptyLR2px);
        FontMetrics fontMetrics = this.labelName.getFontMetrics(this.labelName.getFont());
        int labelHeight = fontMetrics.getHeight();
        int width = GUI.DIM_ICON.width;
        int height = labelHeight;
        this.labelName.setPreferredSize(new Dimension(width, height));
        this.labelName.setMinimumSize(new Dimension(width, height));
        this.labelName.setMaximumSize(new Dimension(width, height));
        this.labelName.setToolTipText("No Item");
        this.imageIcon = new JButton(ItemObjectDAO.getEmptyItem().getItemImage());
        this.imageIcon.setBorder(GUI.borderIconPanel);
        this.imageIcon.setContentAreaFilled(false);
        this.imageIcon.setFocusPainted(false);
        this.imageIcon.setPreferredSize(GUI.DIM_ICON);
        this.imageIcon.setMinimumSize(GUI.DIM_ICON);
        this.imageIcon.setMaximumSize(GUI.DIM_ICON);
        this.imageIcon.setToolTipText("No Item");
        this.imageIcon.addActionListener(this.listenerButton);
        this.popupItem = new PopupClickListener();
        this.imageIcon.addMouseListener(this.popupItem);
        this.add(this.labelTitle);
        this.add(this.panelEquip);
        this.panelEquip.add((Component)this.panelPrefix, "North");
        this.panelPrefix.add((Component)this.buttonPrefix, "Center");
        this.panelEquip.add((Component)this.panelItem, "Center");
        this.panelItem.add((Component)this.labelName, "North");
        this.panelItem.add((Component)this.imageIcon, "Center");
    }
}

