/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;

public final class TerrWriter {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final ByteArrayOutputStream _outputStream = new ByteArrayOutputStream(4096);

    public TerrWriter put(byte b) {
        return this.write(b);
    }

    public TerrWriter put(char c) {
        return this.write(c);
    }

    public TerrWriter put(int i) {
        return this.write(i);
    }

    public TerrWriter putArray(byte[] array, int offset, int length) {
        this._outputStream.write(array, offset, length);
        return this;
    }

    public TerrWriter putArray(byte[] array) {
        this._outputStream.write(array, 0, array.length);
        return this;
    }

    public TerrWriter putBoolean(boolean b) {
        return this.write(b ? 1 : 0);
    }

    public TerrWriter putColor(Color c) {
        return this.write(c.getRed()).write(c.getGreen()).write(c.getBlue());
    }

    public TerrWriter putDouble(double d) {
        return this.putLong(Double.doubleToLongBits(d));
    }

    public TerrWriter putFloat(float f) {
        return this.putInt(Float.floatToIntBits(f));
    }

    public TerrWriter putInt(int i) {
        this.write(i);
        this.write(i >> 8);
        this.write(i >> 16);
        this.write(i >> 24);
        return this;
    }

    public TerrWriter putLong(long l) {
        this.write(l).write(l >> 8);
        this.write(l >> 16).write(l >> 24);
        this.write(l >> 32).write(l >> 40);
        this.write(l >> 48).write(l >> 56);
        return this;
    }

    public TerrWriter putPoint(Point p) {
        return this.putInt(p.x).putInt(p.y);
    }

    public TerrWriter putRectangle(Rectangle r) {
        return this.putInt(r.x).putInt(r.y).putInt(r.width).putInt(r.height);
    }

    public TerrWriter putShort(short s) {
        return this.write(s).write(s >> 8);
    }

    public TerrWriter putString(String s) {
        byte[] sbytes = s.getBytes(CHARSET);
        int count = sbytes.length;
        this.writeStringLength(count);
        this._outputStream.write(sbytes, 0, count);
        return this;
    }

    public TerrWriter putUnsigned(char c) {
        return this.write(c);
    }

    public byte[] toByteArray() {
        return this._outputStream.toByteArray();
    }

    private TerrWriter writeStringLength(int i) {
        int high;
        int value = i;
        do {
            high = value >> 7 & 0x1FFFFFF;
            byte bite = (byte)(value & 0x7F);
            if (high != 0) {
                bite = (byte)(bite | 0x80);
            }
            this.write(bite);
        } while ((value = high) != 0);
        return this;
    }

    private TerrWriter write(long l) {
        this._outputStream.write((int)l);
        return this;
    }

    private TerrWriter write(int i) {
        this._outputStream.write(i);
        return this;
    }
}

