/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.su.slytherin.terraria.ArrayIterator;
import com.su.slytherin.terraria.player.InvStack;
import com.su.slytherin.terraria.player.Item;
import com.su.slytherin.terraria.player.ItemStack;
import java.util.Arrays;
import java.util.Iterator;

public final class Inventory
implements InvStack {
    private final ItemStack[] _stacks;
    private final int _size;

    private Inventory(int size) {
        this._size = size;
        this._stacks = new ItemStack[this._size];
        int i = 0;
        while (i < this._size) {
            this._stacks[i] = ItemStack.of(Item.EMPTY, 0);
            ++i;
        }
    }

    private Inventory(ItemStack[] copy) {
        this._size = copy.length;
        this._stacks = copy;
    }

    @Override
    public Item getItem(int index) {
        this.checkBounds(index);
        return this._stacks[index].getItem();
    }

    @Override
    public Inventory setItem(int index, Item item) {
        this.checkBounds(index);
        this._stacks[index] = ItemStack.of(item);
        return this;
    }

    @Override
    public Inventory setItem(int index, String itemName) {
        return this.setItem(index, Item.of(itemName, 0));
    }

    @Override
    public int getItemCount(int index) {
        this.checkBounds(index);
        return this._stacks[index].getCount();
    }

    @Override
    public Inventory setItemCount(int index, int count) {
        this.checkBounds(index);
        this._stacks[index].setCount(count);
        return this;
    }

    @Override
    public ItemStack getStack(int index) {
        this.checkBounds(index);
        return this._stacks[index].copy();
    }

    @Override
    public Inventory setStack(int index, ItemStack stack) {
        this.checkBounds(index);
        this._stacks[index] = stack.copy();
        return this;
    }

    @Override
    public Inventory setStack(int index, Item item, int count) {
        this.checkBounds(index);
        this._stacks[index] = ItemStack.of(item, count);
        return this;
    }

    @Override
    public Inventory setStack(int index, String itemName, int count) {
        return this.setStack(index, Item.of(itemName, 0), count);
    }

    public static InvStack create(int size) {
        return new Inventory(size);
    }

    public static InvStack createMain() {
        return Inventory.create(40);
    }

    public static InvStack createStartingMain() {
        InvStack inv = Inventory.createMain();
        inv.setItem(0, "Copper Shortsword").setItem(1, "Copper Pickaxe").setItem(2, "Copper Axe");
        return inv;
    }

    public static InvStack createCoins() {
        return Inventory.create(4);
    }

    public static InvStack createAmmo() {
        return Inventory.create(4);
    }

    public static InvStack createPiggyBank() {
        return Inventory.create(20);
    }

    public static InvStack createSafe() {
        return Inventory.create(20);
    }

    private void checkBounds(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Inventory index: " + index + ", size: " + this._size);
        }
    }

    @Override
    public Inventory clear() {
        int i = 0;
        while (i < this._size) {
            this._stacks[i] = ItemStack.of(Item.EMPTY, 0);
            ++i;
        }
        return this;
    }

    @Override
    public Inventory copy() {
        ItemStack[] copy = new ItemStack[this._size];
        int i = 0;
        while (i < this._size) {
            copy[i] = this._stacks[i].copy();
            assert (copy[i] != this._stacks[i]) : "Inventory copy not copying";
            ++i;
        }
        Inventory invcopy = new Inventory(copy);
        assert (invcopy.equals(this)) : "Inventory copy failed";
        return invcopy;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof InvStack)) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Inventory her = (Inventory)obj;
            return this._size == her._size && Arrays.equals(this._stacks, her._stacks);
        }
        InvStack her = (InvStack)obj;
        if (this._size != her.size()) {
            return false;
        }
        int i = 0;
        while (i < this._size) {
            if (!this._stacks[i].equals(her.getStack(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return (31 + this._size) * 31 + Arrays.hashCode(this._stacks);
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return ArrayIterator.wrap(this.copy()._stacks);
    }

    @Override
    public int size() {
        return this._size;
    }

    public String toString() {
        return "Inventory [size=" + this._size + ", stacks=" + Arrays.toString(this._stacks) + "]";
    }
}

