/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.su.slytherin.terraria.Copyable;
import com.su.slytherin.terraria.Razdor;
import com.su.slytherin.terraria.player.BuffList;
import com.su.slytherin.terraria.player.Equipment;
import com.su.slytherin.terraria.player.InvStack;
import com.su.slytherin.terraria.player.Inventory;
import com.su.slytherin.terraria.player.ItemInv;
import com.su.slytherin.terraria.player.Konst;
import com.su.slytherin.terraria.player.SpawnPoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public final class Player
implements Copyable<Player> {
    static final int CURRENT_VERSION = 39;
    private int _version;
    private String _name;
    private int _difficulty;
    private int _hairstyle;
    private boolean _male;
    private int _life;
    private int _lifeMax;
    private int _mana;
    private int _manaMax;
    private Color _hairColor;
    private Color _skinColor;
    private Color _eyeColor;
    private Color _oShirtColor;
    private Color _uShirtColor;
    private Color _pantsColor;
    private Color _shoeColor;
    private ItemInv _armor;
    private ItemInv _accessories;
    private ItemInv _social;
    private InvStack _inventory;
    private InvStack _coins;
    private InvStack _ammo;
    private InvStack _bank;
    private InvStack _safe;
    private BuffList _buffs;
    private final ArrayList<SpawnPoint> _spawnPoints;
    private boolean _hotbarLocked;

    private Player(int version) {
        this._version = version;
        this._spawnPoints = new ArrayList();
    }

    private Player(int version, String name, int difficulty, int hairstyle, boolean gender, int life, int lifeMax, int mana, int manaMax, Color hairColor, Color skinColor, Color eyeColor, Color oShirtColor, Color uShirtColor, Color pantsColor, Color shoeColor, ItemInv armor, ItemInv accessories, ItemInv social, InvStack inventory, InvStack coins, InvStack ammo, InvStack bank, InvStack safe, BuffList buffs, List<SpawnPoint> spawnPoints, boolean hotbarLocked) {
        this._version = version;
        this._name = name;
        this._difficulty = difficulty;
        this._hairstyle = hairstyle;
        this._male = gender;
        this._life = life;
        this._lifeMax = lifeMax;
        this._mana = mana;
        this._manaMax = manaMax;
        this._hairColor = hairColor;
        this._skinColor = skinColor;
        this._eyeColor = eyeColor;
        this._oShirtColor = oShirtColor;
        this._uShirtColor = uShirtColor;
        this._pantsColor = pantsColor;
        this._shoeColor = shoeColor;
        this._armor = (ItemInv)armor.copy();
        this._accessories = (ItemInv)accessories.copy();
        this._social = (ItemInv)social.copy();
        this._inventory = (InvStack)inventory.copy();
        this._coins = (InvStack)coins.copy();
        this._ammo = (InvStack)ammo.copy();
        this._bank = (InvStack)bank.copy();
        this._safe = (InvStack)safe.copy();
        this._buffs = buffs.copy();
        this._spawnPoints = Razdor.copyList(spawnPoints);
        this._hotbarLocked = hotbarLocked;
    }

    public int getVersion() {
        return this._version;
    }

    public Player setVersion(int version) {
        this._version = version;
        return this;
    }

    public String getName() {
        return this._name;
    }

    public Player setName(String name) {
        this._name = Razdor.requireReal(name, "Player name must not be null.");
        return this;
    }

    public char getDifficulty() {
        return (char)this._difficulty;
    }

    public Player setDifficulty(int difficulty) {
        this._difficulty = (char)difficulty;
        return this;
    }

    public int getHairstyle() {
        return this._hairstyle;
    }

    public Player setHairstyle(int hairstyle) {
        this._hairstyle = hairstyle;
        return this;
    }

    public boolean isMale() {
        return this._male;
    }

    public Player setMale(boolean male) {
        this._male = male;
        return this;
    }

    public int getLife() {
        return this._life;
    }

    public Player setLife(int life) {
        this._life = life;
        return this;
    }

    public int getLifeMax() {
        return this._lifeMax;
    }

    public Player setLifeMax(int lifeMax) {
        this._lifeMax = lifeMax;
        return this;
    }

    public int getMana() {
        return this._mana;
    }

    public Player setMana(int mana) {
        this._mana = mana;
        return this;
    }

    public int getManaMax() {
        return this._manaMax;
    }

    public Player setManaMax(int manaMax) {
        this._manaMax = manaMax;
        return this;
    }

    public Color getHairColor() {
        return this._hairColor;
    }

    public Player setHairColor(Color hairColor) {
        this._hairColor = Razdor.requireReal(hairColor);
        return this;
    }

    public Color getSkinColor() {
        return this._skinColor;
    }

    public Player setSkinColor(Color skinColor) {
        this._skinColor = Razdor.requireReal(skinColor);
        return this;
    }

    public Color getEyeColor() {
        return this._eyeColor;
    }

    public Player setEyeColor(Color eyeColor) {
        this._eyeColor = Razdor.requireReal(eyeColor);
        return this;
    }

    public Color getOShirtColor() {
        return this._oShirtColor;
    }

    public Player setOShirtColor(Color oShirtColor) {
        this._oShirtColor = Razdor.requireReal(oShirtColor);
        return this;
    }

    public Color getUShirtColor() {
        return this._uShirtColor;
    }

    public Player setUShirtColor(Color uShirtColor) {
        this._uShirtColor = Razdor.requireReal(uShirtColor);
        return this;
    }

    public Color getPantsColor() {
        return this._pantsColor;
    }

    public Player setPantsColor(Color pantsColor) {
        this._pantsColor = Razdor.requireReal(pantsColor);
        return this;
    }

    public Color getShoeColor() {
        return this._shoeColor;
    }

    public Player setShoeColor(Color shoeColor) {
        this._shoeColor = Razdor.requireReal(shoeColor);
        return this;
    }

    public ItemInv getArmor() {
        return (ItemInv)this._armor.copy();
    }

    public Player setArmor(ItemInv armor) {
        this._armor = (ItemInv)Razdor.requireSize(armor, 3).copy();
        return this;
    }

    public ItemInv getAccessories() {
        return (ItemInv)this._accessories.copy();
    }

    public Player setAccessories(ItemInv accessories) {
        this._accessories = (ItemInv)Razdor.requireSize(accessories, 5).copy();
        return this;
    }

    public ItemInv getSocial() {
        return (ItemInv)this._social.copy();
    }

    public Player setSocial(ItemInv social) {
        this._social = (ItemInv)Razdor.requireSize(social, 3).copy();
        return this;
    }

    public InvStack getInventory() {
        return (InvStack)this._inventory.copy();
    }

    public Player setInventory(InvStack inventory) {
        this._inventory = (InvStack)Razdor.requireSize(inventory, 40).copy();
        return this;
    }

    public InvStack getCoins() {
        return (InvStack)this._coins.copy();
    }

    public Player setCoins(InvStack coins) {
        this._coins = (InvStack)Razdor.requireSize(coins, 4).copy();
        return this;
    }

    public InvStack getAmmo() {
        return (InvStack)this._ammo.copy();
    }

    public Player setAmmo(InvStack ammo) {
        this._ammo = (InvStack)Razdor.requireSize(ammo, 4).copy();
        return this;
    }

    public InvStack getBank() {
        return (InvStack)this._bank.copy();
    }

    public Player setBank(InvStack bank) {
        this._bank = (InvStack)Razdor.requireSize(bank, 20).copy();
        return this;
    }

    public InvStack getSafe() {
        return (InvStack)this._safe.copy();
    }

    public Player setSafe(InvStack safe) {
        this._safe = (InvStack)Razdor.requireSize(safe, 20).copy();
        return this;
    }

    public BuffList getBuffs() {
        return this._buffs.copy();
    }

    public Player setBuffs(BuffList buffs) {
        this._buffs = Razdor.requireSize(buffs, 10).copy();
        return this;
    }

    public List<SpawnPoint> getSpawnPoints() {
        return Razdor.copyList(this._spawnPoints);
    }

    public Player setSpawnPoints(List<SpawnPoint> newSpawns) {
        if (newSpawns.size() > 200) {
            throw new IllegalArgumentException("New SpawnPoint list is too large");
        }
        Razdor.copyList(newSpawns, this._spawnPoints);
        return this;
    }

    public boolean isHotbarLocked() {
        return this._hotbarLocked;
    }

    public Player setHotbarLocked(boolean hotbarLocked) {
        this._hotbarLocked = hotbarLocked;
        return this;
    }

    private Object[] getObjectsArray() {
        return new Object[]{this._hairColor, this._skinColor, this._eyeColor, this._oShirtColor, this._uShirtColor, this._pantsColor, this._shoeColor, this._armor, this._accessories, this._social, this._inventory, this._coins, this._ammo, this._bank, this._safe, this._buffs, this._spawnPoints};
    }

    public Player addSpawnPoint(SpawnPoint spawnPoint) {
        if (this._spawnPoints.size() >= 200) {
            throw new IllegalArgumentException("SpawnPoint list is full, can't add to it");
        }
        this._spawnPoints.add(spawnPoint.copy());
        return this;
    }

    public static Player create() {
        return Player.create("");
    }

    public static Player create(String name) {
        Player player = new Player(39);
        player.setName(name);
        player._difficulty = 0;
        player._hairstyle = 0;
        player._male = true;
        player._life = 100;
        player._lifeMax = 100;
        player._mana = 0;
        player._manaMax = 0;
        player._hairColor = Konst.Colors.HAIR;
        player._skinColor = Konst.Colors.SKIN;
        player._eyeColor = Konst.Colors.EYES;
        player._oShirtColor = Konst.Colors.OSHIRT;
        player._uShirtColor = Konst.Colors.USHIRT;
        player._pantsColor = Konst.Colors.PANTS;
        player._shoeColor = Konst.Colors.SHOES;
        player._armor = Equipment.createArmor();
        player._accessories = Equipment.createAccessories();
        player._social = Equipment.createSocial();
        player._inventory = Inventory.createMain();
        player._coins = Inventory.createCoins();
        player._ammo = Inventory.createAmmo();
        player._bank = Inventory.createPiggyBank();
        player._safe = Inventory.createSafe();
        player._buffs = BuffList.create();
        player._hotbarLocked = false;
        assert (player.isValidState()) : "Invalid Player state in create";
        return player;
    }

    public static Player createDefault(String name) {
        Player player = Player.create();
        player.setName(name);
        player._inventory.setItem(0, "Copper Shortsword").setItem(1, "Copper Pickaxe").setItem(2, "Copper Axe");
        assert (player.isValidState()) : "Invalid Player state in createDefault";
        return player;
    }

    private boolean isValidState() {
        Object[] objectArray = this.getObjectsArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                return false;
            }
            ++n2;
        }
        for (SpawnPoint spawnPoint : this._spawnPoints) {
            if (spawnPoint != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Player copy() {
        Player copy = new Player(this._version, this._name, this._difficulty, this._hairstyle, this._male, this._life, this._lifeMax, this._mana, this._manaMax, this._hairColor, this._skinColor, this._eyeColor, this._oShirtColor, this._uShirtColor, this._pantsColor, this._shoeColor, this._armor, this._accessories, this._social, this._inventory, this._coins, this._ammo, this._bank, this._safe, this._buffs, this._spawnPoints, this._hotbarLocked);
        assert (copy.isValidState()) : "Copy has invalid state";
        assert (copy.equals(this)) : "Player copy failed";
        return copy;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Player player = (Player)object;
        if (!this._name.equals(player._name)) {
            return false;
        }
        if (this._version != player._version) {
            return false;
        }
        if (this._difficulty != player._difficulty) {
            return false;
        }
        if (this._life != player._life) {
            return false;
        }
        if (this._lifeMax != player._lifeMax) {
            return false;
        }
        if (this._male != player._male) {
            return false;
        }
        if (this._mana != player._mana) {
            return false;
        }
        if (this._manaMax != player._manaMax) {
            return false;
        }
        if (!this._eyeColor.equals(player._eyeColor)) {
            return false;
        }
        if (!this._hairColor.equals(player._hairColor)) {
            return false;
        }
        if (this._hairstyle != player._hairstyle) {
            return false;
        }
        if (this._hotbarLocked != player._hotbarLocked) {
            return false;
        }
        if (!this._oShirtColor.equals(player._oShirtColor)) {
            return false;
        }
        if (!this._shoeColor.equals(player._shoeColor)) {
            return false;
        }
        if (!this._skinColor.equals(player._skinColor)) {
            return false;
        }
        if (!this._spawnPoints.equals(player._spawnPoints)) {
            return false;
        }
        if (!this._uShirtColor.equals(player._uShirtColor)) {
            return false;
        }
        if (!this._armor.equals(player._armor)) {
            return false;
        }
        if (!this._accessories.equals(player._accessories)) {
            return false;
        }
        if (!this._social.equals(player._social)) {
            return false;
        }
        if (!this._ammo.equals(player._ammo)) {
            return false;
        }
        if (!this._buffs.equals(player._buffs)) {
            return false;
        }
        if (!this._coins.equals(player._coins)) {
            return false;
        }
        if (!this._inventory.equals(player._inventory)) {
            return false;
        }
        if (!this._pantsColor.equals(player._pantsColor)) {
            return false;
        }
        if (!this._bank.equals(player._bank)) {
            return false;
        }
        return this._safe.equals(player._safe);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._accessories.hashCode();
        result = 31 * result + this._ammo.hashCode();
        result = 31 * result + this._buffs.hashCode();
        result = 31 * result + this._coins.hashCode();
        result = 31 * result + this._difficulty;
        result = 31 * result + this._armor.hashCode();
        result = 31 * result + this._eyeColor.hashCode();
        result = 31 * result + this._hairColor.hashCode();
        result = 31 * result + this._hairstyle;
        result = 31 * result + (this._hotbarLocked ? 1231 : 1237);
        result = 31 * result + this._inventory.hashCode();
        result = 31 * result + this._life;
        result = 31 * result + this._lifeMax;
        result = 31 * result + (this._male ? 1231 : 1237);
        result = 31 * result + this._mana;
        result = 31 * result + this._manaMax;
        result = 31 * result + this._name.hashCode();
        result = 31 * result + this._pantsColor.hashCode();
        result = 31 * result + this._bank.hashCode();
        result = 31 * result + this._safe.hashCode();
        result = 31 * result + this._oShirtColor.hashCode();
        result = 31 * result + this._shoeColor.hashCode();
        result = 31 * result + this._skinColor.hashCode();
        result = 31 * result + this._spawnPoints.hashCode();
        result = 31 * result + this._uShirtColor.hashCode();
        result = 31 * result + this._social.hashCode();
        result = 31 * result + this._version;
        return result;
    }

    public String toString() {
        return "Player [version=" + this._version + ", name=" + this._name + ", difficulty=" + this._difficulty + ", hairstyle=" + this._hairstyle + ", male=" + this._male + ", life=" + this._life + ", lifeMax=" + this._lifeMax + ", mana=" + this._mana + ", manaMax=" + this._manaMax + ", hairColor=" + this._hairColor + ", skinColor=" + this._skinColor + ", eyeColor=" + this._eyeColor + ", oShirtColor=" + this._oShirtColor + ", uShirtColor=" + this._uShirtColor + ", pantsColor=" + this._pantsColor + ", shoeColor=" + this._shoeColor + ", armor=" + this._armor + ", accessories=" + this._accessories + ", social=" + this._social + ", inventory=" + this._inventory + ", coins=" + this._coins + ", ammo=" + this._ammo + ", bank=" + this._bank + ", safe=" + this._safe + ", buffs=" + this._buffs + ", spawnPoints=" + this._spawnPoints + ", hotbarLocked=" + this._hotbarLocked + "]";
    }
}

